'use strict';

app.config(['$routeProvider', function($routeProvider) {
    $routeProvider
        .when('/creator', {
            redirectTo: '/creator/notary'
        })
        .when('/start', {
            templateUrl: '/partials/front/creator/start.html'
        })
        .when('/creator/notary', {
            templateUrl: '/partials/front/creator/notary.html'
            ,resolve: {
                creatorStage: NotaryCtrl.getCreatorStage
                ,usersList: NotaryCtrl.getUsersInGroupForLoggedUser
                ,company: NotaryCtrl.getCompanyForLoggedUser
                ,companyRoleTypes: NotaryCtrl.getCompanyRoleTypes
                ,activeCodesPkd: NotaryCtrl.getActiveCodesPkd
            }
        })
        .when('/creator/estate', {
            templateUrl: '/partials/front/creator/estate.html'
            ,resolve: {
                creatorStage: EstateCtrl.getCreatorStage
                ,placesList: EstateCtrl.getRandomPlaces
                ,company: NotaryCtrl.getCompanyForLoggedUser
                ,companyRoleTypes: NotaryCtrl.getCompanyRoleTypes
            }
        })
        .when('/creator/bank', {
            templateUrl: '/partials/front/creator/bank.html'
            ,resolve: {
                creatorStage: BankCtrl.getCreatorStage
                ,bankServices: BankCtrl.getBankServices
                ,company: NotaryCtrl.getCompanyForLoggedUser
            }
        })
        .when('/creator/officeKRS', {
            templateUrl: '/partials/front/creator/officeKRS.html'
            ,resolve: {
                creatorStage: OfficeKRSCtrl.getCreatorStage
            }
        })
        .otherwise({redirectTo: '/start'});
}]);

